#!/usr/bin/env bash

# This convenience script is provided here as a mirror of the root‑level
# bootstrap_and_run.sh.  It allows you to run the flip‑count simulator
# followed by the Wilson‑loop pipeline from within the vol4-wilson-loop-pipeline
# repository.  Paths are resolved relative to this directory; if the
# sibling repositories ar-operator-core and vol4-flip-count-simulator are
# present adjacent to this directory, the commands will locate and use
# them accordingly.

set -euo pipefail

# Determine workspace root (parent directory of this file)
ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

echo "[bootstrap] Running flip‑count simulator"
# The flip‑count simulator relies on the ``ar-operator-core`` package.  In
# this repository layout the core lives in a nested directory
# ``ar-operator-core/ar-operator-core`` two levels above this script.
# Inject it into PYTHONPATH so that ``generate_flip_counts.py`` can import
# ``flip_operators`` without an editable install.  The simulator itself
# resides in ``vol4-flip-count-simulator/vol4-flip-count-simulator``.
# Prepend the core directory to PYTHONPATH.  If PYTHONPATH is unset then
# parameter expansion using `${PYTHONPATH:+...}` avoids an unbound error
# under ``set -u``.  The resulting PYTHONPATH contains only the core
# directory when previously unset.
export PYTHONPATH="$ROOT_DIR/../../ar-operator-core/ar-operator-core${PYTHONPATH:+:$PYTHONPATH}"
python "$ROOT_DIR/../../vol4-flip-count-simulator/vol4-flip-count-simulator/scripts/generate_flip_counts.py"

echo "[bootstrap] Running Wilson‑loop pipeline"
python "$ROOT_DIR/run_simulation.py" --config "$ROOT_DIR/config.yaml"

echo "[bootstrap] Complete"